function y = diffsigmoid(x,p)

% y = diffsigmoid(x,[a1 c1 a2 c2])
%
% Input Variables
%   x - the time points
%   a1 - slope of start
%   c1 - inflection of start
%   a2 - slope of end
%   c2 - inflection of end
%
% Output Variables
%   y - output signal
%
% Description
%   Generates the difference of two sigmoids as a time series.

% Created     
%   4/20/2006, Richard J. Povinelli, Marquette University
%
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% Modified

y = sigmoid(x, p(1:2)) - sigmoid(x, p(3:4));